//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include <IWAppForm.hpp>
#pragma link "IWIndy_72_60.lib"

#include "IWUnit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "IWCompButton"
#pragma link "IWCompEdit"
#pragma link "IWCompLabel"
#pragma link "IWContainer"
#pragma link "IWControl"
#pragma link "IWHTMLControls"
#pragma link "IWRegion"
#pragma link "IWBaseControl"
#pragma link "IWBaseHTMLControl"
#pragma link "IWHTMLContainer"
#pragma link "IWVCLBaseContainer"
#pragma link "IWVCLBaseControl"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TIWAppForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::linkQuitClick(TObject *Sender)
{
  WebApplication->Terminate("Thank you for playing!");
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::butnGuessClick(TObject *Sender)
{
  int LGuess;

  lablResponse->Caption = "";
  LGuess = StrToIntDef(Trim(editGuess->Text), MaxInt);
  if (LGuess == MaxInt) {
    WebApplication->ShowMessage(editGuess->Text + " is not a valid number.", smAlert, "");
  } else if (LGuess < 1 || LGuess > 100) {
    WebApplication->ShowMessage("Only numbers between 1 and 100 are valid.", smAlert, "");
  } else if (LGuess < FMagicNo) {
    lablResponse->Caption = IntToStr(LGuess) + " is too low.";
    FGuessCount++;
  } else if (LGuess > FMagicNo) {
    lablResponse->Caption = IntToStr(LGuess) + " is too high.";
    FGuessCount++;
  } else if (LGuess == FMagicNo) {
    WebApplication->Terminate("Fantastic! You guessed it in " + IntToStr(FGuessCount) + " guesses.");
  }
  lablResponse->Visible = lablResponse->Caption.Length() > 0;
  lablGuessNo->Caption = "Guess #" + IntToStr(FGuessCount);
  editGuess->Text = "";
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::IWAppFormCreate(TObject *Sender)
{
  randomize();
  FMagicNo = random(100) + 1;
  FGuessCount = 1;
}
//---------------------------------------------------------------------------

void setMainForm() {
  TMainForm::SetAsMainForm(__classid(TMainForm));
}

#pragma startup setMainForm


